/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.util.TimeSpan;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class GorWaitingComputerResult {
    public static final GorWaitingComputerResult EMPTY = new GorWaitingComputerResult(Collections.emptyMap());
    private Map<GeneralizedActionRequest, GarWaitingInfo> waitings;

    public GorWaitingComputerResult(Map<GeneralizedActionRequest, GarWaitingInfo> waitings) {
        this.waitings = waitings;
    }

    public GarWaitingInfo getWaitingInfo(GeneralizedActionRequest gar) {
        return this.waitings.get(gar);
    }

    public Iterable<Map.Entry<GeneralizedActionRequest, GarWaitingInfo>> getWaitings() {
        return this.waitings.entrySet();
    }

    public static class GarWaitingInfo {
        @Nonnull
        public GeneralizedActionRequest gar;
        @Nonnull
        public List<WaitingPiece> waitings;
        @Nonnull
        public Long minimumTimeBefore;

        public GarWaitingInfo(GeneralizedActionRequest gar, @Nonnull List<WaitingPiece> waitings, Long minimumWaiting) {
            this.gar = gar;
            this.waitings = waitings;
            this.minimumTimeBefore = minimumWaiting;
        }
    }

    public static class WaitingPiece {
        public TimeSpan ts;
        public boolean inGar;

        public WaitingPiece(TimeSpan ts, boolean inGar) {
            this.ts = ts;
            this.inGar = inGar;
        }

        public static WaitingPiece create(TimeSpan ts, boolean inGar) {
            return new WaitingPiece(ts, inGar);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WaitingPiece)) {
                return false;
            }
            WaitingPiece that = (WaitingPiece)o;
            return this.inGar == that.inGar && Objects.equals(this.ts, that.ts);
        }

        public int hashCode() {
            int result = this.ts != null ? this.ts.hashCode() : 0;
            result = 31 * result + (this.inGar ? 1 : 0);
            return result;
        }
    }
}

